﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Security.Principal;

namespace IndianHealthService.BMXNet.Net
{
    internal class BMXNetSocketConnectionSpec
    {

        private WindowsIdentity _windowsIdentity = null;

        public WindowsIdentity WindowsIdentity
        {
            get { return _windowsIdentity; }
            set
            {
                _windowsIdentity = value;
                this.UseWindowsAuthentication = value != null;
            }
        }
        private String _encryptedAccessVerifyCode = null;

        public String EncryptedAccessVerifyCode
        {
            get { return _encryptedAccessVerifyCode; }
            set { _encryptedAccessVerifyCode = value; }
        }


        public bool HasNameSpace
        {
            get { return this.NameSpace != null && this.NameSpace.Length > 0; }
        }


        private String _server = null;

        public String Server
        {
            get { return _server; }
            set { _server = value; }
        }

        private int _receiveTimeout = 0;

        public int ReceiveTimeout
        {
            get { return _receiveTimeout; }
            set { _receiveTimeout = value; }
        }
        private int _sendTimeout = 0;

        public int SendTimeout
        {
            get { return _sendTimeout; }
            set { _sendTimeout = value; }
        }

        private int _port = 0;

        public int Port
        {
            get { return _port; }
            set { _port = value; }
        }

        private String _nameSpace = null;

        public String NameSpace
        {
            get { return _nameSpace; }
            set { _nameSpace = value; }
        }

        private bool _useWindowsAuthentication = false;

        public bool UseWindowsAuthentication
        {
            get { return _useWindowsAuthentication; }
            set { _useWindowsAuthentication = value; }
        }
    }
}